/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeDetector;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.GuiDetector;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileDetector
extends TileNode<NetworkNodeDetector> {
    private static final String NBT_POWERED = "Powered";
    public static final TileDataParameter<Integer, TileDetector> COMPARE = FilterConfig.createCompareParameter();
    public static final TileDataParameter<Integer, TileDetector> TYPE = FilterConfig.createFilterTypeParameter();
    public static final TileDataParameter<Integer, TileDetector> MODE = new TileDataParameter<Integer, TileDetector>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeDetector)t.getNode()).getMode(), (t, v) -> {
        if (v == 0 || v == 1 || v == 2) {
            ((NetworkNodeDetector)t.getNode()).setMode((int)v);
            ((NetworkNodeDetector)t.getNode()).markNetworkNodeDirty();
        }
    });
    public static final TileDataParameter<Integer, TileDetector> AMOUNT = new TileDataParameter<Integer, TileDetector>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeDetector)t.getNode()).getAmount(), (t, v) -> {
        ((NetworkNodeDetector)t.getNode()).setAmount((int)v);
        ((NetworkNodeDetector)t.getNode()).markNetworkNodeDirty();
    }, (initial, p) -> GuiBase.executeLater(GuiDetector.class, detector -> detector.getAmount().func_146180_a(String.valueOf(p))));

    public TileDetector() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(AMOUNT);
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        ((NetworkNodeDetector)this.getNode()).setPowered(tag.func_74767_n(NBT_POWERED));
        super.readUpdate(tag);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_POWERED, ((NetworkNodeDetector)this.getNode()).isPowered());
        return tag;
    }

    @Override
    @Nonnull
    public NetworkNodeDetector createNode(World world, BlockPos pos) {
        return new NetworkNodeDetector(world, pos);
    }

    @Override
    public String getNodeId() {
        return "detector";
    }
}

